/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.EntityFlameRing;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemFireRod
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_fire.png");
    private static final int COST = 900;
    private static final int COOLDOWN = 1200;

    public ItemFireRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockPos pos = ctx.m_8083_();
        if (!world.f_46443_ && player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, false)) {
            EntityFlameRing entity = (EntityFlameRing)ModEntities.FLAME_RING.m_20615_(world);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_((Item)this, ManaItemHandler.instance().hasProficiency(player, stack) ? 600 : 1200);
            }
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, true);
            ctx.m_43725_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.fireRod, player != null ? SoundSource.PLAYERS : SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public static class AvatarBehavior
    implements IAvatarWieldable {
        @Override
        public void onAvatarUpdate(IAvatarTile tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.m_58904_();
            IManaReceiver receiver = IXplatAbstractions.INSTANCE.findManaReceiver(world, te.m_58899_(), te.m_58900_(), te, null);
            if (!world.f_46443_ && receiver.getCurrentMana() >= 900 && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
                EntityFlameRing entity = (EntityFlameRing)ModEntities.FLAME_RING.m_20615_(world);
                entity.m_6034_((double)te.m_58899_().m_123341_() + 0.5, te.m_58899_().m_123342_(), (double)te.m_58899_().m_123343_() + 0.5);
                world.m_7967_((Entity)entity);
                receiver.receiveMana(-900);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(IAvatarTile tile) {
            return avatarOverlay;
        }
    }
}

